<?php
//API DÙNG CHO NẠP GAME GARENA, ZING, NẠP ĐIỆN THOẠI ... TẠI DOITHE1S.VN


// LIÊN HỆ DOITHE1S.VN ĐỂ ALLOW IP MỚI CÓ THỂ DÙNG API TOPUP
// TẠO API : https://doithe1s.vn/merchant/list
class doithe1s
{
    private $partner_id = '';
    private $partner_key = '';
    private $post_url = 'https://doithe1s.vn/api/rechargews';

    public function charge()
    {
        // Thông tin mẫu
        $request_id = rand(100000, 999999); // Mã giao dịch duy nhất
        $service_code = 'freefirepackage'; //mã dịch vụ: dùng api lấy danh sách dịch vụ để lấy mã dịch vụ
        $amount = '10000'; // số tiền tương ứng
        $quantity = '1'; // số lượng tương ứng, thường sẽ đặt mặc định là 1, không cần thiết
        $account_info = ['game_id' => '1234567890'];
        //truyền 'game_id' nếu là game garena, 
        //truyền 'phone' nếu là nạp điện thoại 
        //truyền 'username' + 'password' nếu nạp game yêu cầu ( liên quân , fo4 chẳng hạn)
        //Dùng api getProducts để lấy mã dịch vụ và các options tương ứng với dịch vụ đó
        $data = [
            'partner_id'   => $this->partner_id,
            'command'      => 'topup',
            'request_id'   => $request_id,
            'service_code' => $service_code,
            'amount'       => $amount,
            'qty'          => $quantity,
            'account_info' => $account_info,
            'sign'         => md5($this->partner_key . $this->partner_id . 'topup' . $request_id)
        ];
        $response = $this->sendRequest($data);
        $response = json_decode($response, true);
        if ($response['status'] == '114') {
            die("Liên hệ admin doithe1s.vn allow ip server/hosting của bạn để sử dụng");
        } else {
            return json_encode($response);
        }
        //EXAMPLE RESPONSE:
        /*
        {
            "status": "success",
            "data": {
              "time": "2022-04-15 15:50:20",
              "request_id": "116",
              "order_code": "R625931CC50F71",
              "pay_amount": 10000,
              "discount": 0,
              "service_code": "vinatt",
              "amount": 10000,
              "status": "pending"
            }
          }
        */
    }
    public function getStatus()
    {
        // Thông tin mẫu
        $request_id = '123456'; // Mã giao dịch mà bạn gửi lêncho doithe1s.vn
        $order_code = 'ORDER_ABC123'; // Mã đơn hàng (order_code) do hệ thống trả về khi tạo đơn hàng thành công

        $data = [
            'partner_id'  => $this->partner_id,
            'command'     => 'getstatus',
            'request_id'  => $request_id,
            'order_code'  => $order_code,
            'sign'        => md5($this->partner_key . $this->partner_id . 'getstatus' . $request_id)
        ];
        /* EXAMPLE RESPONSE:
        Tương tự res khi tạo đơn
        */
        return $this->sendRequest($data);
    }

    public function balance()
    {
        $data = [
            'partner_id' => $this->partner_id,
            'command'    => 'getbalance',
            'sign'       => md5($this->partner_key . $this->partner_id . 'getbalance')
        ];
        /* EXAMPLE RESPONSE:
        {
       "status": "success",
        "data": {
        "balance": 85465019,
        "currency": "VND"
       }
     } 
        */
        return $this->sendRequest($data);
    }

    public function getProducts()
    {
        $data = [
            'partner_id' => $this->partner_id,
            'command'    => 'productlist',
            'sign'       => md5($this->partner_key . $this->partner_id . 'productlist')
        ];
        $response = $this->sendRequest($data);
        $response = json_decode($response, true);
        if ($response['status'] == '114') {
            die("Liên hệ admin doithe1s.vn allow ip server/hosting của bạn để sử dụng");
        } else {
            return json_encode($response);
        }
    }

    private function sendRequest($data)
    {
        $ch = curl_init($this->post_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            return json_encode([
                'status' => 'error',
                'message' => curl_error($ch)
            ]);
        }

        curl_close($ch);
        return $response;
    }
}


$api = new doithe1s('Partner ID	', 'Partner Key	');
// Test 1: Gửi yêu cầu nạp
$response = $api->getProducts();
echo $response;
echo "<br>";


/*CALLBACK MẪU SAU KHI ĐƠN HÀNG ĐƯỢC XỬ LÝ TRẢ VỀ URL MÀ KHÁCH THÊM Ở https://doithe1s.vn/merchant/list:
{
  "time": 1718372897, // thời gian gửi callback
  "account": "testuser123",
  "request_id": "REQ123456",
  "order_code": "ORDER789XYZ",
  "pay_amount": 20000,
  "discount": 10,
  "service_code": "freefire",
  "status": "canceled", // canceled là hủy, //completed là hoàn thành 
  "callback_sign": "e10adc3949ba59abbe56e057f20f883e" // chữ ký dùng để xác thực (md5(partner_key + partner_id + command + request_id))
}
*/




/* Res mẫu lấy danh sách dịch vụ:
"{
    "status": "success",
    "data": [{
        "name": "Viettel tr\u1ea3 sau (N\u1ea1p ngay)",
        "service_code": "viettelts",
        "cat_id": 3,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/the-viettel.png",
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "10,000 \u0111",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": 7
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 199,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Viettel tr\u1ea3 tr\u01b0\u1edbc (N\u1ea1p ngay)",
        "service_code": "vietteltt",
        "cat_id": 3,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/the-viettel.png",
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7
        }, {
            "name": "10,000 \u0111",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": 7
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i n\u1ea1p",
            "type": "input",
            "format_input": "int",
            "sort": 1,
            "id": 14,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Vinaphone (N\u1ea1p ngay)",
        "service_code": "vinatt",
        "cat_id": 3,
        "type": null,
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/the-vinaphone.jpeg",
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 3.5
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 3.5
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 3.5
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 3.5
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 3.5
        }, {
            "name": "10,000 \u0111",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": "8"
        }, {
            "name": "1,000,000 \u0111",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": "8"
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i n\u1ea1p",
            "type": "input",
            "format_input": "phone",
            "sort": 1,
            "id": 16,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Mobifone (N\u1ea1p ngay)",
        "service_code": "mobitt",
        "cat_id": 3,
        "type": null,
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/the-mobifone.jpeg",
        "items": [{
            "name": "10,000 \u0111",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": "8.5"
        }, {
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": "8.5"
        }, {
            "name": "30,000 \u0111",
            "value": 30000,
            "price": "30000",
            "currency_code": "VND",
            "discount": "8.5"
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 3
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 3
        }, {
            "name": "1,000,000 \u0111",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": 3
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 3
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 3
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i n\u1ea1p",
            "type": "input",
            "format_input": "phone",
            "sort": 1,
            "id": 15,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p qu\u00e2n huy li\u00ean qu\u00e2n",
        "service_code": "lienquan",
        "cat_id": 28,
        "type": "game",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/lienquan_x.jpg",
        "items": [{
            "name": "1 \u0111",
            "value": 1,
            "price": null,
            "currency_code": "VND",
            "discount": 9
        }],
        "options": [{
            "key": "username",
            "name": "T\u00ean \u0111\u0103ng nh\u1eadp GARENA",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 111,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "password",
            "name": "M\u1eadt kh\u1ea9u GARENA",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 112,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "amount",
            "name": "S\u1ed1 ti\u1ec1n",
            "type": "input",
            "format_input": "float",
            "sort": 0,
            "id": 113,
            "min_value": 20000,
            "max_value": 50000000,
            "multiple_value": 10000,
            "option_value": []
        }]
    }, {
        "name": "Gunny Origin",
        "service_code": "gunnyorigin",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/gno-icon.png",
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "1,000,000 \u0111",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "Role ID",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 114,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Kim c\u01b0\u01a1ng freefire (Xong 1s)",
        "service_code": "freefire",
        "cat_id": 28,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/topup\/freefire.png",
        "items": [{
            "name": "20,000 - 113 kim c\u01b0\u01a1ng",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "50,000 - 283 kim c\u01b0\u01a1ng",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "100,000 - 566 kim c\u01b0\u01a1ng",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "200,000 - 1132 kim c\u01b0\u01a1ng",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "500,000 - 2830 kim c\u01b0\u01a1ng",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "5,000 - 25 kim c\u01b0\u01a1ng",
            "value": 5000,
            "price": "5000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "10,000 - 51 kim c\u01b0\u01a1ng",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": 9.5
        }],
        "options": [{
            "key": "game_id",
            "name": "ID Game",
            "type": "input",
            "format_input": "int",
            "sort": 0,
            "id": 123,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Fifa Online",
        "service_code": "fo4",
        "cat_id": 28,
        "type": "game",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/fifa_x.jpg",
        "items": [{
            "name": "1 \u0111",
            "value": 1,
            "price": null,
            "currency_code": "VND",
            "discount": 9
        }],
        "options": [{
            "key": "amount",
            "name": "S\u1ed1 ti\u1ec1n n\u1ea1p",
            "type": "input",
            "format_input": "float",
            "sort": 0,
            "id": 127,
            "min_value": 20000,
            "max_value": 2000000,
            "multiple_value": 10000,
            "option_value": []
        }, {
            "key": "username",
            "name": "T\u00ean \u0111\u0103ng nh\u1eadp GARENA",
            "type": "input",
            "format_input": "text",
            "sort": 1,
            "id": 125,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "password",
            "name": "M\u1eadt kh\u1ea9u GARENA",
            "type": "input",
            "format_input": "text",
            "sort": 1,
            "id": 126,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Fifa Online 4 Mobile",
        "service_code": "fo4m",
        "cat_id": 28,
        "type": "game",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/fifaonline_x.jpg",
        "items": [{
            "name": "1 \u0111",
            "value": 1,
            "price": null,
            "currency_code": "VND",
            "discount": 9
        }],
        "options": [{
            "key": "amount",
            "name": "S\u1ed1 ti\u1ec1n mu\u1ed1n n\u1ea1p",
            "type": "input",
            "format_input": "float",
            "sort": 0,
            "id": 130,
            "min_value": 20000,
            "max_value": 20000000,
            "multiple_value": 10000,
            "option_value": []
        }, {
            "key": "username",
            "name": "T\u00e0i kho\u1ea3n GARENA",
            "type": "input",
            "format_input": "text",
            "sort": 1,
            "id": 128,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "password",
            "name": "M\u1eadt kh\u1ea9u GARENA",
            "type": "input",
            "format_input": "text",
            "sort": 1,
            "id": 129,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "C\u00e1i Th\u1ebf Tranh H\u00f9ng",
        "service_code": "caithetranhhung",
        "cat_id": 28,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/caitheanhhung_x.jpg",
        "items": [{
            "name": "20,000 \u0111 - 26 kim phi\u1ebfu",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 9
        }, {
            "name": "50,000 \u0111 - 67 kim phi\u1ebfu",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 9
        }, {
            "name": "100,000 \u0111 - 134 kim phi\u1ebfu",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 9
        }, {
            "name": "200,000 \u0111 - 268 kim phi\u1ebfu",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 9
        }, {
            "name": "500,000 \u0111 - 670 kim phi\u1ebfu",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 9
        }],
        "options": [{
            "key": "game_id",
            "name": "ID t\u00e0i kho\u1ea3n",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 131,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p Vcoin",
        "service_code": "vcoin",
        "cat_id": 28,
        "type": "game",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/vcoin_x.jpg",
        "items": [{
            "name": "1 \u0111",
            "value": 1,
            "price": "1",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "username",
            "name": "T\u00ean t\u00e0i kho\u1ea3n",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 134,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "amount",
            "name": "S\u1ed1 ti\u1ec1n",
            "type": "input",
            "format_input": "float",
            "sort": 0,
            "id": 135,
            "min_value": 20000,
            "max_value": 500000000,
            "multiple_value": 10000,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p Li\u00ean Minh T\u1ed1c Chi\u1ebfn",
        "service_code": "tocchien",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/tocchien-icon.png",
        "items": [{
            "name": "50,000 \u0111 - G\u00f3i 250 Wild Cores",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111 - G\u00f3i 500 Wild Cores",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111 - G\u00f3i 1050 Wild Cores",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111 - G\u00f3i 2825 Wild Cores",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "1,000,000 \u0111 -G\u00f3i 5825 Wild Cores",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "Riot ID ho\u1eb7c t\u00ean \u0111\u0103ng nh\u1eadp",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 136,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Li\u00ean Minh Huy\u1ec1n Tho\u1ea1i PC",
        "service_code": "lienminh",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/lol-icon.png",
        "items": [{
            "name": "50,000 \u0111 - 340RP",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111 - 690 RP",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111 - 1.400RP",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111 - 3.500RP",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "1,000,000 \u0111 - 7.250RP",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "Riot ID",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 138,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "\u0110\u1ea5u Tr\u01b0\u1eddng Ch\u00e2n L\u00fd Mobile",
        "service_code": "dtcl",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/TFT_M-appicon-300x300.png",
        "items": [{
            "name": "50,000 \u0111 - 340TC",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111 - 690 TC",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111 - 1.400 TC",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111 - 3.550TC",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "1,000,000 \u0111 - 7.250TC",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "Riot ID ho\u1eb7c t\u00ean ng\u01b0\u1eddi d\u00f9ng",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 143,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p Ti\u1ec1n Valorant PC",
        "service_code": "valorant",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/valorant-icon-2.png",
        "items": [{
            "name": "10,000 \u0111 - 50VP",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "20,000 \u0111 - 105VP",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "50,000 \u0111 - 268VP",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111 - 535VP",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111 - 1100VP",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111 - 2895VP",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "Riot ID ho\u1eb7c t\u00ean \u0111\u0103ng nh\u1eadp",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 144,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p s\u00f2 garena (Ch\u1eadm)",
        "service_code": "so",
        "cat_id": 28,
        "type": "game",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/a.jpg",
        "items": [{
            "name": "1 \u0111",
            "value": 1,
            "price": null,
            "currency_code": "VND",
            "discount": 9
        }],
        "options": [{
            "key": "username",
            "name": "T\u00e0i Kho\u1ea3n Garena",
            "type": "input",
            "format_input": "text",
            "sort": 0,
            "id": 146,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "amount",
            "name": "S\u1ed1 ti\u1ec1n n\u1ea1p",
            "type": "input",
            "format_input": "float",
            "sort": 0,
            "id": 147,
            "min_value": 20000,
            "max_value": 20000000,
            "multiple_value": 10000,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p s\u00f2 garena (Xong nhanh)",
        "service_code": "sonhanh",
        "cat_id": 28,
        "type": "game",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/thecao\/a.jpg",
        "items": [{
            "name": "1 \u0111",
            "value": 1,
            "price": null,
            "currency_code": "VND",
            "discount": 7
        }],
        "options": [{
            "key": "username",
            "name": "T\u00e0i Kho\u1ea3n Garena",
            "type": "input",
            "format_input": "text",
            "sort": 2,
            "id": 188,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }, {
            "key": "amount",
            "name": "S\u1ed1 ti\u1ec1n n\u1ea1p",
            "type": "input",
            "format_input": "float",
            "sort": 5,
            "id": 187,
            "min_value": 20000,
            "max_value": 20000000,
            "multiple_value": 10000,
            "option_value": []
        }]
    }, {
        "name": "N\u1ea1p Robux Roblox VNG Ch\u00ednh H\u00e3ng",
        "service_code": "roblox",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/topup\/roblox-appicon.jpg",
        "items": [{
            "name": "50,000 \u0111 - 145 robux",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111 - 300 robux",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111 - 640 robux",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": "9.5"
        }, {
            "name": "500,000 \u0111 - 1.600 robux",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": "9.5"
        }, {
            "name": "1,000,000 \u0111 - 3.200 robux",
            "value": 1000000,
            "price": "1000000",
            "currency_code": "VND",
            "discount": "9.5"
        }, {
            "name": "20,000 \u0111 - 55 Robux",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "\u0110i\u1ec1n t\u00ean \u0111\u0103ng nh\u1eadp",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 185,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Th\u1ebb tu\u1ea7n,th\u00e1ng,n\u00e2ng c\u1ea5p freefire (Xong 1s)",
        "service_code": "freefirepackage",
        "cat_id": 28,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/topup\/logo.png",
        "items": [{
            "name": "Vip Tu\u1ea7n Ti\u1ebft Ki\u1ec7m",
            "value": 12000,
            "price": "12000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb s\u00fang n\u00e2ng c\u1ea5p - 3 ng\u00e0y",
            "value": 14000,
            "price": "14000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb s\u00fang n\u00e2ng c\u1ea5p - 7 ng\u00e0y",
            "value": 21000,
            "price": "21000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb tu\u1ea7n",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb Booyah",
            "value": 55000,
            "price": "55000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb s\u00fang n\u00e2ng c\u1ea5p - 30 ng\u00e0y",
            "value": 57000,
            "price": "57000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb th\u00e1ng",
            "value": 220000,
            "price": "220000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb L\u00ean C\u1ea5p",
            "value": 49999,
            "price": "49999",
            "currency_code": "VND",
            "discount": "10.5"
        }, {
            "name": "Th\u1ebb l\u00ean c\u1ea5p 6",
            "value": 5000,
            "price": "5000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb l\u00ean c\u1ea5p 10",
            "value": 10000,
            "price": "10000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb l\u00ean c\u1ea5p 15",
            "value": 10001,
            "price": "10001",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb l\u00ean c\u1ea5p 20",
            "value": 10002,
            "price": "10002",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb l\u00ean c\u1ea5p 30",
            "value": 15000,
            "price": "15000",
            "currency_code": "VND",
            "discount": 9.5
        }, {
            "name": "Th\u1ebb l\u00ean c\u1ea5p 25",
            "value": 10003,
            "price": "10003",
            "currency_code": "VND",
            "discount": 9.5
        }],
        "options": [{
            "key": "game_id",
            "name": "ID game",
            "type": "input",
            "format_input": "int",
            "sort": null,
            "id": 192,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "\u0110\u00e1 qu\u00fd PlayTogether",
        "service_code": "daquypltgt",
        "cat_id": 29,
        "type": "mobile",
        "image": "https:\/\/doithe1s.vn\/storage\/userfiles\/images\/topup\/huongdan-ptgvn.png",
        "items": [{
            "name": "100,000 \u0111 (G\u00f3i Ch\u1ed3ng \u0110\u00e1 Qu\u00fd)",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111 (G\u00f3i B\u1eafp Rang \u0110\u00e1 Qu\u00fd)",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "game_id",
            "name": "Nh\u1eadp ID",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 200,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Viettel tr\u1ea3 tr\u01b0\u1edbc (N\u1ea1p ch\u1edd)",
        "service_code": "viettelttcham",
        "cat_id": 3,
        "type": "mobile",
        "image": null,
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 204,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Viettel tr\u1ea3 sau (N\u1ea1p ch\u1edd)",
        "service_code": "vietteltscham",
        "cat_id": 3,
        "type": "mobile",
        "image": null,
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 203,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Vinaphone (N\u1ea1p ch\u1edd)",
        "service_code": "vinacham",
        "cat_id": 3,
        "type": "mobile",
        "image": null,
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 7.5
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 7.5
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 202,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }, {
        "name": "Mobifone (N\u1ea1p ch\u1edd)",
        "service_code": "mobicham",
        "cat_id": 3,
        "type": "mobile",
        "image": null,
        "items": [{
            "name": "20,000 \u0111",
            "value": 20000,
            "price": "20000",
            "currency_code": "VND",
            "discount": 5.5
        }, {
            "name": "50,000 \u0111",
            "value": 50000,
            "price": "50000",
            "currency_code": "VND",
            "discount": 8.5
        }, {
            "name": "100,000 \u0111",
            "value": 100000,
            "price": "100000",
            "currency_code": "VND",
            "discount": 8.5
        }, {
            "name": "200,000 \u0111",
            "value": 200000,
            "price": "200000",
            "currency_code": "VND",
            "discount": 8.5
        }, {
            "name": "500,000 \u0111",
            "value": 500000,
            "price": "500000",
            "currency_code": "VND",
            "discount": 8.5
        }],
        "options": [{
            "key": "phone",
            "name": "S\u1ed1 \u0111i\u1ec7n tho\u1ea1i",
            "type": "input",
            "format_input": "text",
            "sort": null,
            "id": 201,
            "min_value": null,
            "max_value": null,
            "multiple_value": null,
            "option_value": []
        }]
    }]
} ";

*/